/*
 * 功能：模块初始化日志信息
 * 编写日期: 2014-03-05
 * 作者:     David.Dai@zkteco.com 
 * param $click_button：被单击的按钮
 * param title：日志的标题
 * param model_url：模块的model_url地址
 */
function init_log($click_button,title,model_url){
    $click_button.click(function(event){
        var href=$(this).attr("ref");
          var query=$(this).attr("query");
          var t_search_fields=
              [
                  title,
                  '<td><label class="" for="username">'+gettext("用户名")+'</label></td>'
                  +'<td><input type="text" maxlength="30" name="username" id="username" fieldname="user__username"></td>'
                  +'<td><label class="" for="action_flag">'+gettext("动作标志")+'</label></td>'
                  +'<td><select id="action_flag" name="action_flag" fieldname="action_flag">'
                          +'<option selected="selected" value="">---------</option>'
                          +'<option value="1"> '+gettext("增加")+'</option>'
                          +'<option value="2">'+gettext("修改")+'</option>'
                          +'<option value="3">'+gettext("删除")+'</option>'
                          +'<option value="6">'+gettext("导出")+'</option>'
                          +'<option value="4">'+gettext("其他")+'</option>'
                      +'</select>'
                  +'</td>'
                  ];
          var d=new Date();
          if(href.indexOf("?")==-1){
              href=href+"?stamp="+d.getTime();
          }else{
              href=href+"&stamp="+d.getTime();
          }
        $.ajax({
            type:"GET",
            dataType:"html",
            data:query+"&model_url="+model_url,
            url:href,
            success:function(msg){
                var options = {
                    title: t_search_fields[0],
                    content: msg,
                    skin: 'search_dialog',
                    maxmin: true,
                    success: function(layero, index){
                        $("#id_form_search tr", layero).prepend(t_search_fields[1]);
                        $("#id_form_search tr", layero).find("input").keydown(function(event){
                            if(event.keyCode==13){
                                layero.find("#id_header_search").click();
                            }
                        });
                    }
                };
                $(msg).layerDialog(options);
            },
            error:function(one,two,three){
                alert(gettext("服务器加载数据失败,请重试!"));
            }
        });
        return false;
    });
}